"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseObjectsPropertyDefinition = void 0;
const ResponseActions_1 = require("../Enumerations/ResponseActions");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const PropertyDefinition_1 = require("./PropertyDefinition");
class ResponseObjectsPropertyDefinition extends PropertyDefinition_1.PropertyDefinition {
    /**
     * @internal Gets a value indicating whether this property definition is for a nullable type (ref, int?, bool?...).
     */
    get IsNullable() { return false; }
    /**
     * Gets the response action.
     *
     * @param   {string}   responseActionString   The response action string.
     * @return  {ResponseActions}       ResponseActions
     */
    static GetResponseAction(responseActionString) {
        var value = ResponseActions_1.ResponseActions.None;
        switch (responseActionString) {
            case XmlElementNames_1.XmlElementNames.AcceptItem:
                value = ResponseActions_1.ResponseActions.Accept;
                break;
            case XmlElementNames_1.XmlElementNames.TentativelyAcceptItem:
                value = ResponseActions_1.ResponseActions.TentativelyAccept;
                break;
            case XmlElementNames_1.XmlElementNames.DeclineItem:
                value = ResponseActions_1.ResponseActions.Decline;
                break;
            case XmlElementNames_1.XmlElementNames.ReplyToItem:
                value = ResponseActions_1.ResponseActions.Reply;
                break;
            case XmlElementNames_1.XmlElementNames.ForwardItem:
                value = ResponseActions_1.ResponseActions.Forward;
                break;
            case XmlElementNames_1.XmlElementNames.ReplyAllToItem:
                value = ResponseActions_1.ResponseActions.ReplyAll;
                break;
            case XmlElementNames_1.XmlElementNames.CancelCalendarItem:
                value = ResponseActions_1.ResponseActions.Cancel;
                break;
            case XmlElementNames_1.XmlElementNames.RemoveItem:
                value = ResponseActions_1.ResponseActions.RemoveFromCalendar;
                break;
            case XmlElementNames_1.XmlElementNames.SuppressReadReceipt:
                value = ResponseActions_1.ResponseActions.SuppressReadReceipt;
                break;
            case XmlElementNames_1.XmlElementNames.PostReplyItem:
                value = ResponseActions_1.ResponseActions.PostReply;
                break;
        }
        return value;
    }
    /**
     * @internal Loads the property value from json.
     *
     * @param   {any}               jsObject         The JSON value.  Can be a JsonObject, string, number, bool, array, or null.
     * @param   {ExchangeService}   service       The service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    LoadPropertyValueFromXmlJsObject(jsObject, service, propertyBag) {
        let responseActionValue = ResponseActions_1.ResponseActions.None;
        for (let key in jsObject) {
            if (key.indexOf("__") === 0) //skip xmljsobject conversion entries like __type and __prefix
                continue;
            if (jsObject.hasOwnProperty(key)) {
                responseActionValue |= ResponseObjectsPropertyDefinition.GetResponseAction(key);
            }
        }
        propertyBag._setItem(this, responseActionValue);
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer              The writer.
     * @param   {PropertyBag}           propertyBag         The property bag.
     * @param   {boolean}               isUpdateOperation   Indicates whether the context is an update operation.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) { }
}
exports.ResponseObjectsPropertyDefinition = ResponseObjectsPropertyDefinition;
//# sourceMappingURL=ResponseObjectsPropertyDefinition.js.map