"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceObjectPropertyDefinition = void 0;
const ExchangeVersion_1 = require("../Enumerations/ExchangeVersion");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const EwsLogging_1 = require("../Core/EwsLogging");
const ExtensionMethods_1 = require("../ExtensionMethods");
const PropertyDefinitionBase_1 = require("./PropertyDefinitionBase");
/**
 * Represents a property definition for a service object.
 */
class ServiceObjectPropertyDefinition extends PropertyDefinitionBase_1.PropertyDefinitionBase {
    constructor(uri = null) {
        super();
        this.uri = null;
        if (arguments.length == 1) {
            EwsLogging_1.EwsLogging.Assert(!ExtensionMethods_1.StringHelper.IsNullOrEmpty(uri), "ServiceObjectPropertyDefinition.ctor", "uri is null or empty");
            this.uri = uri;
        }
    }
    /**
     * Gets the minimum Exchange version that supports this property.
     *
     * @value {ExchangeVersion} The version.
     */
    // @ts-ignore
    get Version() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Gets the URI of the property definition.
     */
    get Uri() { return this.uri; }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.FieldURI; }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FieldURI, this.Uri);
    }
}
exports.ServiceObjectPropertyDefinition = ServiceObjectPropertyDefinition;
//# sourceMappingURL=ServiceObjectPropertyDefinition.js.map