"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StringPropertyDefinition = void 0;
const TypedPropertyDefinition_1 = require("./TypedPropertyDefinition");
/**
 * @internal Represents String property definition.
 */
class StringPropertyDefinition extends TypedPropertyDefinition_1.TypedPropertyDefinition {
    /**
     * @internal Gets a value indicating whether this property definition is for a nullable type (ref, int?, bool?...).
     */
    get IsNullable() { return true; }
    /**
     * @internal Gets the property type.
     */
    get Type() { return StringPropertyDefinition; } //System.Type;
    /**
     * @internal Initializes a new instance of the **StringPropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version);
    }
    /**
     * @internal Parses the specified value.
     *
     * @param   {string}   value   The value.
     * @return  {any}           String value.
     */
    Parse(value) { return value; }
}
exports.StringPropertyDefinition = StringPropertyDefinition;
//# sourceMappingURL=StringPropertyDefinition.js.map