"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationIndexedItemView = void 0;
const ConversationQueryTraversal_1 = require("../Enumerations/ConversationQueryTraversal");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const ExtensionMethods_1 = require("../ExtensionMethods");
const OffsetBasePoint_1 = require("../Enumerations/OffsetBasePoint");
const OrderByCollection_1 = require("./OrderByCollection");
const ServiceObjectType_1 = require("../Enumerations/ServiceObjectType");
const ViewFilter_1 = require("../Enumerations/ViewFilter");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const PagedView_1 = require("./PagedView");
/**
 * Represents the view settings in a folder search operation.
 *
 * @sealed
 */
class ConversationIndexedItemView extends PagedView_1.PagedView {
    constructor(pageSize, offset = 0, offsetBasePoint = OffsetBasePoint_1.OffsetBasePoint.Beginning) {
        super(pageSize, offset, offsetBasePoint);
        this.orderBy = new OrderByCollection_1.OrderByCollection();
        this.traversal = null;
        this.viewFilter = null;
    }
    /**
     * Gets the properties against which the returned items should be ordered.
     */
    get OrderBy() {
        return this.orderBy;
    }
    /**
     * Gets or sets the conversation query traversal mode.
     *
     * @Nullable
     */
    get Traversal() {
        return this.traversal;
    }
    set Traversal(value) {
        this.traversal = value;
    }
    /**
     * Gets or sets the view filter.
     *
     * @Nullable
     */
    get ViewFilter() {
        return this.viewFilter;
    }
    set ViewFilter(value) {
        this.viewFilter = value;
    }
    /**
     * @internal Gets the type of service object this view applies to.
     *
     * @return  {ServiceObjectType}      A ServiceObjectType value.
     */
    GetServiceObjectType() {
        return ServiceObjectType_1.ServiceObjectType.Conversation;
    }
    /**
     * @internal Gets the name of the view XML element.
     *
     * @return  {type}      XML element name.
     */
    GetViewXmlElementName() {
        return XmlElementNames_1.XmlElementNames.IndexedPageItemView;
    }
    /**
     * @internal Validates this view.
     *
     * @param   {ServiceRequestBase}   request   The request using this view.
     */
    InternalValidate(request) {
        super.InternalValidate(request);
        if ((0, ExtensionMethods_1.hasValue)(this.Traversal)) {
            EwsUtilities_1.EwsUtilities.ValidateEnumVersionValue(ConversationQueryTraversal_1.ConversationQueryTraversal, this.traversal, request.Service.RequestedServerVersion, "ConversationQueryTraversal");
        }
        if (this.ViewFilter) {
            EwsUtilities_1.EwsUtilities.ValidateEnumVersionValue(ViewFilter_1.ViewFilter, this.viewFilter, request.Service.RequestedServerVersion, "ViewFilter");
        }
    }
    /**
     * @internal Writes the search settings to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer    The writer.
     * @param   {Grouping}              groupBy   The group by clause.
     */
    InternalWriteSearchSettingsToXml(writer, groupBy) {
        super.InternalWriteSearchSettingsToXml(writer, groupBy);
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        if ((0, ExtensionMethods_1.hasValue)(this.Traversal)) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Traversal, ConversationQueryTraversal_1.ConversationQueryTraversal[this.Traversal]);
        }
        if (this.ViewFilter) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.ViewFilter, ViewFilter_1.ViewFilter[this.ViewFilter]);
        }
    }
    /**
     * @internal Writes OrderBy property to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteOrderByToXml(writer) {
        this.orderBy.WriteToXml(writer, XmlElementNames_1.XmlElementNames.SortOrder);
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer    The writer.
     * @param   {Grouping}              groupBy   The group by clause.
     */
    WriteToXml(writer, groupBy) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, this.GetViewXmlElementName());
        this.InternalWriteViewToXml(writer);
        writer.WriteEndElement(); // this.GetViewXmlElementName()
    }
}
exports.ConversationIndexedItemView = ConversationIndexedItemView;
//# sourceMappingURL=ConversationIndexedItemView.js.map