"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindConversationResults = void 0;
/**
 * Represents the results of an conversation search operation.
 *
 * @sealed
 */
class FindConversationResults {
    /**
     * @internal Initializes a new instance of the **FindConversationResults** class.
     */
    constructor() {
        /**
         * Gets a collection containing the conversations that were found by the search operation.
         */
        this.Conversations = [];
        /**
         * Gets a collection containing the HighlightTerms that were returned by the search operation.
         */
        this.HighlightTerms = [];
        /**
         * Gets the total count of conversations in view.
         */
        this.TotalCount = null;
        /**
         * Gets the indexed offset of the first conversation by the search operation.
         */
        this.IndexedOffset = null;
    }
}
exports.FindConversationResults = FindConversationResults;
//# sourceMappingURL=FindConversationResults.js.map