"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindFoldersResults = void 0;
/**
 * Represents the results of a folder search operation.
 *
 * @sealed
 */
class FindFoldersResults {
    /**
     * @internal Initializes a new instance of the **FindFoldersResults** class.
     *
     */
    constructor() {
        this.totalCount = 0;
        this.nextPageOffset = null;
        this.moreAvailable = false;
        this.folders = [];
    }
    /**
     * Gets the total number of folders matching the search criteria available in the searched folder.
     */
    get TotalCount() {
        return this.totalCount;
    }
    set TotalCount(value) {
        this.totalCount = value;
    }
    /**
     * Gets the offset that should be used with FolderView to retrieve the next page of folders in a FindFolders operation.
     */
    get NextPageOffset() {
        return this.nextPageOffset;
    }
    set NextPageOffset(value) {
        this.nextPageOffset = value;
    }
    /**
     * Gets a value indicating whether more folders matching the search criteria.
     */
    get MoreAvailable() {
        return this.moreAvailable;
    }
    set MoreAvailable(value) {
        this.moreAvailable = value;
    }
    /**
     * Gets a collection containing the folders that were found by the search operation.
     */
    get Folders() {
        return this.folders;
    }
    /**
     *  Returns an enumerator that iterates through the collection. this case this.items
     */
    GetEnumerator() {
        return this.folders;
    }
}
exports.FindFoldersResults = FindFoldersResults;
//# sourceMappingURL=FindFoldersResults.js.map