"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindItemsResults = void 0;
/**
 * Represents the results of an item search operation.
 *
 * @sealed
 * @type    {TItem}  Item type
 */
class FindItemsResults {
    /**
     * @internal Initializes a new instance of the **FindItemsResults<T>** class.
     */
    constructor() {
        this.totalCount = 0;
        this.nextPageOffset = null;
        this.moreAvailable = false;
        this.items = [];
        this.highlightTerms = [];
    }
    /**
     * Gets the total number of items matching the search criteria available in the searched folder.
     */
    get TotalCount() {
        return this.totalCount;
    }
    set TotalCount(value) {
        this.totalCount = value;
    }
    /**
     * Gets the offset that should be used with ItemView to retrieve the next page of items in a FindItems operation.
     */
    get NextPageOffset() {
        return this.nextPageOffset;
    }
    set NextPageOffset(value) {
        this.nextPageOffset = value;
    }
    /**
     * Gets a value indicating whether more items matching the search criteria are available in the searched folder.
     */
    get MoreAvailable() {
        return this.moreAvailable;
    }
    set MoreAvailable(value) {
        this.moreAvailable = value;
    }
    /**
     * Gets a collection containing the items that were found by the search operation.
     */
    get Items() {
        return this.items;
    }
    /**
     * Gets a collection containing the highlight terms that were found by the search operation.
     */
    get HighlightTerms() {
        return this.highlightTerms;
    }
}
exports.FindItemsResults = FindItemsResults;
//# sourceMappingURL=FindItemsResults.js.map