"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FolderView = void 0;
const FolderTraversal_1 = require("../Enumerations/FolderTraversal");
const OffsetBasePoint_1 = require("../Enumerations/OffsetBasePoint");
const ServiceObjectType_1 = require("../Enumerations/ServiceObjectType");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const PagedView_1 = require("./PagedView");
/**
 * Represents the view settings in a folder search operation.
 *
 * @sealed
 */
class FolderView extends PagedView_1.PagedView {
    constructor(pageSize, offset = 0, offsetBasePoint = OffsetBasePoint_1.OffsetBasePoint.Beginning) {
        super(pageSize, offset, offsetBasePoint);
        this.traversal = FolderTraversal_1.FolderTraversal.Shallow;
    }
    /**
     * Gets or sets the search traversal mode. Defaults to FolderTraversal.Shallow.     *
     */
    get Traversal() {
        return this.traversal;
    }
    set Traversal(value) {
        this.traversal = value;
    }
    /**
     * @internal Gets the type of service object this view applies to.
     *
     * @return  {ServiceObjectType}      A ServiceObjectType value.
     */
    GetServiceObjectType() { return ServiceObjectType_1.ServiceObjectType.Folder; }
    /**
     * @internal Gets the name of the view XML element.
     *
     * @return  {type}      XML element name.
     */
    GetViewXmlElementName() { return XmlElementNames_1.XmlElementNames.IndexedPageFolderView; }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) { writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Traversal, FolderTraversal_1.FolderTraversal[this.Traversal]); }
}
exports.FolderView = FolderView;
//# sourceMappingURL=FolderView.js.map