"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemView = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const ItemTraversal_1 = require("../Enumerations/ItemTraversal");
const OffsetBasePoint_1 = require("../Enumerations/OffsetBasePoint");
const OrderByCollection_1 = require("./OrderByCollection");
const ServiceObjectType_1 = require("../Enumerations/ServiceObjectType");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const PagedView_1 = require("./PagedView");
/**
 * Represents the view settings in a folder search operation.
 *
 * @sealed
 */
class ItemView extends PagedView_1.PagedView {
    constructor(pageSize, offset = 0, offsetBasePoint = OffsetBasePoint_1.OffsetBasePoint.Beginning) {
        super(pageSize, offset, offsetBasePoint);
        this.traversal = ItemTraversal_1.ItemTraversal.Shallow;
        this.orderBy = new OrderByCollection_1.OrderByCollection();
    }
    /**
     * Gets or sets the search traversal mode. Defaults to ItemTraversal.Shallow.
     */
    get Traversal() {
        return this.traversal;
    }
    set Traversal(value) {
        this.traversal = value;
    }
    /**
     * Gets the properties against which the returned items should be ordered.
     */
    get OrderBy() { return this.orderBy; }
    /**
     * @internal Gets the type of service object this view applies to.
     *
     * @return  {ServiceObjectType}      A ServiceObjectType value.
     */
    GetServiceObjectType() { return ServiceObjectType_1.ServiceObjectType.Item; }
    /**
     * @internal Gets the name of the view XML element.
     *
     * @return  {type}      XML element name.
     */
    GetViewXmlElementName() { return XmlElementNames_1.XmlElementNames.IndexedPageItemView; }
    /**
     * @internal Validates this view.
     *
     * @param   {ServiceRequestBase}   request   The request using this view.
     */
    InternalValidate(request) {
        super.InternalValidate(request);
        EwsUtilities_1.EwsUtilities.ValidateEnumVersionValue(ItemTraversal_1.ItemTraversal, this.Traversal, request.Service.RequestedServerVersion, "ItemTraversal");
    }
    /**
     * @internal Writes the search settings to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer    The writer.
     * @param   {Grouping}              groupBy   The group by clause.
     */
    InternalWriteSearchSettingsToXml(writer, groupBy) {
        super.InternalWriteSearchSettingsToXml(writer, groupBy);
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Traversal, ItemTraversal_1.ItemTraversal[this.Traversal]);
    }
    /**
     * @internal Writes OrderBy property to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteOrderByToXml(writer) {
        this.orderBy.WriteToXml(writer, XmlElementNames_1.XmlElementNames.SortOrder);
    }
}
exports.ItemView = ItemView;
//# sourceMappingURL=ItemView.js.map