"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PagedView = void 0;
const OffsetBasePoint_1 = require("../Enumerations/OffsetBasePoint");
const Strings_1 = require("../Strings");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const ViewBase_1 = require("./ViewBase");
/**
 * Represents a view settings that support paging in a search operation.
 */
class PagedView extends ViewBase_1.ViewBase {
    constructor(pageSize, offset = 0, offsetBasePoint = OffsetBasePoint_1.OffsetBasePoint.Beginning) {
        super();
        this.pageSize = 0;
        this.offsetBasePoint = OffsetBasePoint_1.OffsetBasePoint.Beginning;
        this.offset = 0;
        this.pageSize = pageSize;
        this.Offset = offset;
        this.OffsetBasePoint = offsetBasePoint;
    }
    /**
     * The maximum number of items or folders the search operation should return.
     */
    get PageSize() { return this.pageSize; }
    set PageSize(value) {
        if (value <= 0) {
            throw new Error(Strings_1.Strings.ValueMustBeGreaterThanZero);
        }
        this.pageSize = value;
    }
    /**
     * Gets or sets the base point of the offset.
     */
    get OffsetBasePoint() {
        return this.offsetBasePoint;
    }
    set OffsetBasePoint(value) {
        this.offsetBasePoint = value;
    }
    /**
     * Gets or sets the offset.
     */
    get Offset() { return this.offset; }
    set Offset(value) {
        if (value >= 0) {
            this.offset = value;
        }
        else {
            throw new Error(Strings_1.Strings.OffsetMustBeGreaterThanZero);
        }
    }
    ;
    /**
     * @internal Gets the maximum number of items or folders the search operation should return.
     *
     * @return  {number?}      The maximum number of items or folders that should be returned by the search operation.
     */
    GetMaxEntriesReturned() { return this.PageSize; }
    /**
     * @internal Validates this view.
     *
     * @param   {ServiceRequestBase}   request   The request using this view.
     */
    InternalValidate(request) { super.InternalValidate(request); }
    /**
     * @internal Writes the search settings to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer    The writer.
     * @param   {Grouping}              groupBy   The group by clause.
     */
    InternalWriteSearchSettingsToXml(writer, groupBy) {
        if (groupBy !== null && typeof groupBy !== 'undefined') {
            groupBy.WriteToXml(writer);
        }
    }
    /**
     * @internal Writes this view to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    InternalWriteViewToXml(writer) {
        super.InternalWriteViewToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Offset, this.Offset);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.BasePoint, OffsetBasePoint_1.OffsetBasePoint[this.OffsetBasePoint]);
    }
    /**
     * @internal Writes OrderBy property to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteOrderByToXml(writer) {
        /* No order by for paged view*/
    }
}
exports.PagedView = PagedView;
//# sourceMappingURL=PagedView.js.map