"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Change = void 0;
const ChangeType_1 = require("../Enumerations/ChangeType");
/**
 * Represents a change as returned by a synchronization operation.
 */
class Change {
    /**
     * @internal Initializes a new instance of **Change** class.
     */
    constructor() {
        /**
         * The type of change.
         */
        this.changeType = ChangeType_1.ChangeType.Create;
        /**
         * The service object the change applies to.
         */
        this.serviceObject = null;
        /**
         * The Id of the service object the change applies to.
         */
        this.id = null;
    }
    /**
     * Gets the type of the change.
     */
    get ChangeType() {
        return this.changeType;
    }
    set ChangeType(value) {
        this.changeType = value;
    }
    /**
     * @internal Gets or sets the service object the change applies to.
     */
    get ServiceObject() {
        return this.serviceObject;
    }
    set ServiceObject(value) {
        this.serviceObject = value;
    }
    /**
     * @internal Gets or sets the Id of the service object the change applies to.
     */
    get Id() {
        return this.ServiceObject != null ? this.ServiceObject.GetId() : this.id;
    }
    set Id(value) {
        this.id = value;
    }
}
exports.Change = Change;
//# sourceMappingURL=Change.js.map