"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigureForOutlook = exports.XHROutlook = void 0;
const ConfigurationApi_1 = require("./ConfigurationApi");
class XHROutlook {
    xhr(xhroptions, progressDelegate) {
        return new Promise((resolve, reject) => {
            Office.context.mailbox.makeEwsRequestAsync(xhroptions.data, (result) => {
                let res = {
                    status: 200,
                    responseText: result.value,
                    getAllResponseHeaders: () => [],
                    getResponseHeader: (str) => ""
                };
                if (result.status === 'succeeded') {
                    resolve(res);
                }
                else {
                    res.message = result.error.message;
                    res.status = 500;
                    reject(res);
                }
            });
        });
    }
    xhrStream(xhroptions, progressDelegate) {
        return new Promise((resolve, reject) => {
            reject(new Error("not implemented/ not used"));
        });
    }
    disconnect() {
    }
    get apiName() {
        return "outlook";
    }
    constructor() {
    }
}
exports.XHROutlook = XHROutlook;
function ConfigureForOutlook() {
    ConfigurationApi_1.ConfigurationApi.ConfigureXHR(new XHROutlook());
}
exports.ConfigureForOutlook = ConfigureForOutlook;
//# sourceMappingURL=XHROutlook.js.map